/* ****************************************************************************
 * Copyright: 2017-2025 RAYLASE GmbH
 * This source code is the proprietary confidential property of RAYLASE GmbH.
 * Reproduction, publication, or any form of distribution to
 * any party other than the licensee is strictly prohibited.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef RL_API_H_
#define RL_API_H_

#include <stddef.h>
#include <stdint.h>
#include <time.h>

#ifdef _WIN32
	#ifdef RL_COMPILING_DLL
		#define RL_API __declspec(dllexport)
	#else
		#define RL_API __declspec(dllimport)
	#endif
#elif defined(__GNUC__) || defined(__clang__)
	#define RL_API __attribute__((visibility("default")))
#else
	#define RL_API
#endif
#ifdef __cplusplus
	#define RL_C_API extern "C" RL_API
#else
	#define RL_C_API extern RL_API
#endif

RL_C_API const uint32_t rlMaxHostnameLen; // This maximum is no longer enforced. This variables is deprecated.
RL_C_API const uint32_t rlMaxFilenameLen;
RL_C_API const uint32_t rlMaxTextLen;
RL_C_API const uint32_t rlMaxListDocumentLen;

RL_C_API void rlGetLastError(char* buffer, int32_t bufferSize);
RL_C_API int32_t rlGetLastErrorLen(void);

#endif